package com.ejie.p06b.manager;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.dao.P06B20T00DAO;
import com.ejie.p06b.dao.P06B22T00DAO;
import com.ejie.p06b.dao.P06B25T00DAO;
import com.ejie.p06b.dao.P06B26T00DAO;
import com.ejie.p06b.dao.P06B27T00DAO;
import com.ejie.p06b.dao.P06B28T00DAO;
import com.ejie.p06b.dao.P06B29T00DAO;
import com.ejie.p06b.dao.P06B30T00DAO;
import com.ejie.p06b.dao.P06B31T00DAO;
import com.ejie.p06b.dao.P06B32T00DAO;
import com.ejie.p06b.dao.P06B33T00DAO;
import com.ejie.p06b.dao.P06B34T00DAO;
import com.ejie.p06b.dao.P06B35T00DAO;
import com.ejie.p06b.dao.P06B36T00DAO;
import com.ejie.p06b.dao.P06B37T00DAO;
import com.ejie.p06b.dao.P06B38T00DAO;
import com.ejie.p06b.dao.P06B39T00DAO;
import com.ejie.p06b.dao.P06B40T00DAO;
import com.ejie.p06b.dao.P06B42T00DAO;
import com.ejie.p06b.dao.P06B43T00DAO;
import com.ejie.p06b.dao.P06B44T00DAO;
import com.ejie.p06b.dao.P06B45T00DAO;
import com.ejie.p06b.dao.P06B46T00DAO;
import com.ejie.p06b.dao.P06B47T00DAO;
import com.ejie.p06b.dao.P06B48T00DAO;
import com.ejie.p06b.dao.P06B49T00DAO;
import com.ejie.p06b.dao.P06B50T00DAO;
import com.ejie.p06b.dao.P06B51T00DAO;
import com.ejie.p06b.dao.P06B52T00DAO;
import com.ejie.p06b.dao.P06B53T00DAO;
import com.ejie.p06b.dao.P06B60T00DAO;
import com.ejie.p06b.dao.P06B61T00DAO;
import com.ejie.p06b.dao.P06B64T00DAO;
import com.ejie.p06b.dao.P06B23T00DAO;
import com.ejie.p06b.dao.P06B24T00DAO;
import com.ejie.p06b.dao.P06B81T00DAO;
import com.ejie.p06b.dao.P06B82T00DAO;
import com.ejie.p06b.dao.P06B83T00DAO;
import com.ejie.p06b.dao.P06BJoinsDAO;
import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDEC;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDECDet;
import com.ejie.p06b.datatype.logic.pagination.P06BAtencionPeticionesPagination;
import com.ejie.p06b.datatype.logic.pagination.P06BCorredorPagination;
import com.ejie.p06b.datatype.logic.pagination.P06BDECPagination;
import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B25T00Datatype;
import com.ejie.p06b.datatype.model.P06B26T00Datatype;
import com.ejie.p06b.datatype.model.P06B27T00Datatype;
import com.ejie.p06b.datatype.model.P06B28T00Datatype;
import com.ejie.p06b.datatype.model.P06B29T00Datatype;
import com.ejie.p06b.datatype.model.P06B30T00Datatype;
import com.ejie.p06b.datatype.model.P06B31T00Datatype;
import com.ejie.p06b.datatype.model.P06B32T00Datatype;
import com.ejie.p06b.datatype.model.P06B35T00Datatype;
import com.ejie.p06b.datatype.model.P06B37T00Datatype;
import com.ejie.p06b.datatype.model.P06B39T00Datatype;
import com.ejie.p06b.datatype.model.P06B40T00Datatype;
import com.ejie.p06b.datatype.model.P06B45T00Datatype;
import com.ejie.p06b.datatype.model.P06B48T00Datatype;
import com.ejie.p06b.datatype.model.P06B49T00Datatype;
import com.ejie.p06b.datatype.model.P06B50T00Datatype;
import com.ejie.p06b.datatype.model.P06B51T00Datatype;
import com.ejie.p06b.datatype.model.P06B52T00Datatype;
import com.ejie.p06b.datatype.model.P06B53T00Datatype;
import com.ejie.p06b.datatype.model.P06B60T00Datatype;
import com.ejie.p06b.datatype.model.P06B61T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.datatype.model.P06B23T00Datatype;
import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.datatype.model.P06B81T00Datatype;
import com.ejie.p06b.datatype.model.P06B83T00Datatype;
import com.ejie.p06b.datatype.supramodel.InformeComunicarDGSFP2;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BPage;
import com.ejie.p06b.util.P06BPaginator;

/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * 
 * Manager para la gestin del corredor (Pantallas mdulo corredores)
 * 
 * Fecha de creacin: (25/05/07)
 */
public class P06BCorredoresManager {
	
	static private P06BCorredoresManager instance = null;

	public static P06BCorredoresManager getInstance() {
	     if (instance == null) {
	          synchronized (P06BCorredoresManager.class) {
	          		if (instance == null) {
	                     instance = new P06BCorredoresManager();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Inserta un registro en la BD -> De momento en la P06B20T00
    * 
    * @param obj 
    * 			Elemento que deseamos insertar
    * @return String
    * 			El Expediente creado
    * @throws P06BException
    */
	public String insertCorredor(P06B20T00Datatype obj) throws P06BException{
		try {
			String expediente = P06B20T00DAO.getInstance().insert(obj);
			String clase = obj.getClase();
			if ( P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA.equals(clase) ||
					P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA.equals(clase) ||
					P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA.equals(clase) ||
					P06BConstantes.P06B_AGENTEVINCULADO_FISICA.equals(clase) ){
				P06B60T00Datatype datosCapacidadFinanciera = obj.getDatosCapacidadFinanciera();
				datosCapacidadFinanciera.setnExpediente(expediente);
				P06B60T00DAO.getInstance().insert(datosCapacidadFinanciera);				
			}
			return expediente;
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Modifica un registro en la BD -> De momento en la P06B20T00
    * 
    * @param obj 
    * 			Elemento que deseamos actualizar
    * @return String
    * 			El Expediente modificado
    * @throws P06BException
    */
	public String updateCorredor(P06B20T00Datatype obj) throws P06BException{
		try {
			return P06B20T00DAO.getInstance().update(obj);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - updateCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Modifica un registro en la BD -> De momento en la P06B20T00
    * 
    * @param obj 
    * 			Elemento que deseamos actualizar
    * @return String
    * 			El Expediente modificado
    * @throws P06BException
    */
	public void updateEstadoAtencionPeticion(int correlativo, byte estadoAtencionPeticion) throws P06BException{
		try {
			P06B64T00DAO.getInstance().update(correlativo, estadoAtencionPeticion);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - updateCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Modifica un registro en la BD -> De momento en la P06B20T00
    * 
    * @param obj 
    * 			Elemento que deseamos actualizar
    * @return String
    * 			El Expediente modificado
    * @throws P06BException
    */
	public void updateCapacidadFinanciera(P06B60T00Datatype datosCapacidadFinanciera) throws P06BException{
		try {
			P06B60T00DAO.getInstance().delete(datosCapacidadFinanciera.getnExpediente());
			P06B60T00DAO.getInstance().insert(datosCapacidadFinanciera);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - updateCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Obtiene un registro P06B20T00Datatype a partir de la clave primaria -> N Exp.
    * 
    * @param numExp 
    * 			Clave primaria de la tabla en BD
    * @return P06B20T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B20T00Datatype selectCorredor(String numExp) throws P06BException{
		try {
			return P06B20T00DAO.getInstance().select(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B60T00Datatype a partir de la clave primaria -> N Exp.
    * 
    * @param numExp 
    * 			Clave primaria de la tabla en BD
    * @return P06B60T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B60T00Datatype selectCapacidadFinanciera(String numExp) throws P06BException{
		try {
			return P06B60T00DAO.getInstance().select(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B20T00Datatype a partir de la clave primaria -> N Exp.
    * 
    * @param numExp 
    * 			Clave primaria de la tabla en BD
    * @return P06B20T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B20T00Datatype selectCorredorIncorporacion(String numExp, int nEjerIncorporarDEC) throws P06BException{
		try {
			return P06B20T00DAO.getInstance().selectIncorporacion(numExp, nEjerIncorporarDEC);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    */
	public P06B20T00Datatype selectCorredorCorrelAtencionPeticionEnRevision(String numExp, P06B64T00Datatype p06B64T00Datatype) throws P06BException{
		try {
			return P06B20T00DAO.getInstance().selectCorredorCorrelAtencionPeticionEnRevision(numExp, p06B64T00Datatype);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCorredorCorrelAtencionPeticionEnRevision: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    */
	public P06B60T00Datatype selectCapacidadFinancieraCorrelAtencionPeticionEnRevision2(String numExp, int nCorrelAtencionPeticionEnRevision, P06B60T00Datatype capacidadFinanciera) throws P06BException{
		try {
			return P06B60T00DAO.getInstance().selectCapacidadFinancieraCorrelAtencionPeticionEnRevision2(numExp, nCorrelAtencionPeticionEnRevision, capacidadFinanciera);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCapacidadFinancieraCorrelAtencionPeticionEnRevision: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    */
	public P06B60T00Datatype selectIncorporacion(String numExp, int nEjerIncorporarDEC, P06B60T00Datatype capacidadFinanciera) throws P06BException{
		try {
			return P06B60T00DAO.getInstance().selectIncorporacion(numExp, nEjerIncorporarDEC, capacidadFinanciera);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCapacidadFinancieraCorrelAtencionPeticionEnRevision: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	/**
    * Obtiene un registro P06B23T00Datatype a partir de la clave primaria -> N Exp.
    * 
    * @param numExp 
    * 			Clave primaria de la tabla en BD
    * @return P06B23T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B23T00Datatype selectAseguradora(String claveCat) throws P06BException{
		try {
			return P06B23T00DAO.getInstance().select(claveCat);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAseguradora: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
	    * Obtiene un registro P06B23T00Datatype a partir de la clave primaria -> N Exp.
	    * 
	    * @param numExp 
	    * 			Clave primaria de la tabla en BD
	    * @return P06B23T00Datatype
	    * 			ValueObject obtenido
	    * @throws P06BException
	    */
	public P06B23T00Datatype selectAseguradoraByCIF(String cif) throws P06BException{
		try {
			return P06B23T00DAO.getInstance().selectByCIF(cif);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAseguradoraByCIF: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	/**
    * Obtiene los N registros pertenecientes al listado de corredores de la pagina N
    * 
    * @param numPag
    * 			nmero de pgina cuyos N registros deseo obtener
    * @param where
    * 			where a aadir a la sentencia
    * @return P06BPage
    * 			Objeto con la informacin y la Lista de objetos P06BIPagination
    * @throws P06BException
    */
	public P06BPage getListadoCorredores(String codigoVuelta, String columnaVuelta, int numPag, String where) throws P06BException{
		try {
			String sentencia = P06B20T00DAO.getInstance().getStrListadoCorredores(where);
			return P06BPaginator.getElements(numPag,P06BConstantes.P06B_NUM_REG_PAG,sentencia,codigoVuelta,columnaVuelta,new P06BCorredorPagination());
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - getListadoCorredores: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	
	/**
    * Obtiene los N registros pertenecientes al listado de corredores de la pagina N
    * 
    * @param numPag
    * 			nmero de pgina cuyos N registros deseo obtener
    * @param where
    * 			where a aadir a la sentencia
    * @return P06BPage
    * 			Objeto con la informacin y la Lista de objetos P06BIPagination
    * @throws P06BException
    */
	public P06BPage getListadoAtencionPeticiones(String codigoVuelta, String columnaVuelta, HttpServletRequest request, int numPag, String where) throws P06BException{
		try {
			String sentencia = P06B64T00DAO.getInstance().getStrListadoAtencionPeticiones(request, where);
			return P06BPaginator.getElements(numPag,P06BConstantes.P06B_NUM_REG_PAG,sentencia,codigoVuelta,columnaVuelta,new P06BAtencionPeticionesPagination());
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - getListadoAtencionPeticiones: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Inserta los socios asociados al expediente
    * 
    * @param listaSocios 
    * 			Lista de socios a insertar
    * @param exp 
    * 			Expediente al que se asocia cada socio
    * @throws P06BException
    */
	public void insertSocios(ArrayList listaSocios, String exp) throws P06BException{
		try {
			if(listaSocios.isEmpty())
				return;
			for(int i=0;i<listaSocios.size();i++){
				//Recorro los socios a insertar
				P06B22T00Datatype socio = (P06B22T00Datatype)listaSocios.get(i);
				socio.setNExpediente(exp);
				P06B22T00DAO.getInstance().insert(socio);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertSocios: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Inserta los socios asociados al expediente
    * 
    * @param listaSocios 
    * 			Lista de socios a insertar
    * @param exp 
    * 			Expediente al que se asocia cada socio
    * @throws P06BException
    */
	public void insertEVs(ArrayList listaEVs, String exp) throws P06BException{
		try {
			if(listaEVs.isEmpty())
				return;
			for(int i=0;i<listaEVs.size();i++){
				//Recorro las EVs a insertar
				P06B61T00Datatype ev = (P06B61T00Datatype)listaEVs.get(i);
				ev.setExpedi(exp);
				P06B61T00DAO.getInstance().insert(ev);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertEVs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
		
	/**
    * Inserta los socios indirectos asociados al expediente
    * 
    * @param listaSociosIndirec 
    * 			Lista de socios indirectos a insertar
    * @param exp 
    * 			Expediente al que se asocia cada socio indirecto
    * @throws P06BException
    */
	public void insertSociosIndirec(ArrayList listaSociosIndirec, String exp) throws P06BException{
		try {
			if(listaSociosIndirec.isEmpty())
				return;
			for(int i=0;i<listaSociosIndirec.size();i++){
				//Recorro los socios a insertar
				P06B22T00Datatype socio = (P06B22T00Datatype)listaSociosIndirec.get(i);
				socio.setNExpediente(exp);
				P06B22T00DAO.getInstance().insert(socio);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertSociosIndirec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Inserta los auxiliares externos asociados al expediente
    * 
    * @param listaAuxExternos 
    * 			Lista de auxiliares externos a insertar
    * @param exp 
    * 			Expediente al que se asocia cada auxiliares externos
    * @throws P06BException
    */
	public void insertAuxExternos(ArrayList listaAuxExternos, String exp) throws P06BException{
		try {
			if(listaAuxExternos.isEmpty())
				return;
			for(int i=0;i<listaAuxExternos.size();i++){
				//Recorro los socios a insertar
				P06B22T00Datatype socio = (P06B22T00Datatype)listaAuxExternos.get(i);
				socio.setNExpediente(exp);
				P06B22T00DAO.getInstance().insert(socio);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertAuxExternos: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Inserta los organos de direccin asociados al expediente
    * 
    * @param listaOrganos 
    * 			Lista de organos de direccin a insertar
    * @param exp 
    * 			Expediente al que se asocia cada rgano de direccin
    * @throws P06BException
    */
	public void insertOrganosDir(ArrayList listaOrganos, String exp) throws P06BException{
		try {
			if(listaOrganos.isEmpty())
				return;
			for(int i=0;i<listaOrganos.size();i++){
				//Recorro los socios a insertar
				P06B24T00Datatype org = (P06B24T00Datatype)listaOrganos.get(i);
				org.setnExpediente(exp);
				P06B24T00DAO.getInstance().insert(org);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertOrganosDir: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Inserta la direccin tcnica asociados al expediente
    * 
    * @param listaDirecTec 
    * 			Lista de direccin tcnica a insertar
    * @param exp 
    * 			Expediente al que se asocia cada direccin tcnica
    * @throws P06BException
    */
	public void insertDirecTec(ArrayList listaDirecTec, String exp) throws P06BException{
		try {
			if(listaDirecTec.isEmpty())
				return;
			for(int i=0;i<listaDirecTec.size();i++){
				//Recorro los socios a insertar
				P06B24T00Datatype org = (P06B24T00Datatype)listaDirecTec.get(i);
				org.setnExpediente(exp);
				P06B24T00DAO.getInstance().insert(org);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertDirecTec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Inserta las otras personas de direccin asociados al expediente
    * 
    * @param listaOtrosDirec 
    * 			Lista de organos de direccin a insertar
    * @param exp 
    * 			Expediente al que se asocia cada rgano de direccin
    * @throws P06BException
    */
	public void insertOtrosDirec(ArrayList listaOtrosDirec, String exp) throws P06BException{
		try {
			if(listaOtrosDirec.isEmpty())
				return;
			for(int i=0;i<listaOtrosDirec.size();i++){
				//Recorro los socios a insertar
				P06B24T00Datatype org = (P06B24T00Datatype)listaOtrosDirec.get(i);
				org.setnExpediente(exp);
				P06B24T00DAO.getInstance().insert(org);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertOtrosDirec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Inserta los administradores asociados al expediente
    * 
    * @param listaAdministradores 
    * 			Lista de administradores a insertar
    * @param exp 
    * 			Expediente al que se asocia cada administrador
    * @throws P06BException
    */
	public void insertAdministradores(ArrayList listaAdministradores, String exp) throws P06BException{
		try {
			if(listaAdministradores.isEmpty())
				return;
			for(int i=0;i<listaAdministradores.size();i++){
				//Recorro los socios a insertar
				P06B24T00Datatype org = (P06B24T00Datatype)listaAdministradores.get(i);
				org.setnExpediente(exp);
				P06B24T00DAO.getInstance().insert(org);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertAdministradores: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
		
	/**
    * Inserta las sucursales asociadas al expediente
    * 
    * @param listaSucursales 
    * 			Lista de sucursales a insertar
    * @param exp 
    * 			Expediente al que se asocia cada sucursal
    * @throws P06BException
    */
	public void insertSucursales(ArrayList listaSucursales, String exp) throws P06BException{
		try {
			if(listaSucursales.isEmpty())
				return;
			for(int i=0;i<listaSucursales.size();i++){
				//Recorro los socios a insertar
				P06B25T00Datatype sucurs = (P06B25T00Datatype)listaSucursales.get(i);
				sucurs.setNumExp(exp);
				//Se asigna el valor del correlativo
				sucurs.setCorr((i+1)+"");
				P06B25T00DAO.getInstance().insert(sucurs);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertSucursales: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Inserta los defensores de cliente asociados al expediente
    * 
    * @param listaDefensores 
    * 			Lista de defensores de cleinte a insertar
    * @param exp 
    * 			Expediente al que se asocia cada defensor de cliente
    * @throws P06BException
    */
	public void insertDefCliente(ArrayList listaDefensores, String exp) throws P06BException{
		try {
			if(listaDefensores.isEmpty())
				return;
			ArrayList listaPFDef = null;
			for(int i=0;i<listaDefensores.size();i++){
				listaPFDef = null;
				//Recorro los defensores de cliente a insertar
				P06B29T00Datatype defCliente = (P06B29T00Datatype)listaDefensores.get(i);
				defCliente.setNumExp(exp);
				P06B29T00DAO.getInstance().insert(defCliente);
				
				//En caso de que el defensor sea jurdico, se insertarn las personas fsicas que lo forman
				listaPFDef = defCliente.getListaPF_DefCliente();
				if(listaPFDef != null && listaPFDef.size() > 0){
					//Recorro las personas fsicas del defensor
					for(int j=0;j<listaPFDef.size();j++){
						P06B30T00Datatype PFDefCliente = (P06B30T00Datatype)listaPFDef.get(j);
						PFDefCliente.setNumExp(exp);
						//Le asignamos como identificador el del defensor y en el identificador1 ir el de la propia persona fsica
						PFDefCliente.setIdentificador(defCliente.getIdentificador());
						P06B30T00DAO.getInstance().insert(PFDefCliente);
					}					
				}				
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertDefCliente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Inserta los departamentos de atencin al cliente asociados al expediente
    * 
    * @param listaDepAtCliente 
    * 			Lista de departamentos de atencin al cliente a insertar
    * @param exp 
    * 			Expediente al que se asocia cada departamento de atencin al cliente
    * @throws P06BException
    */
	public void insertDepAtCliente(ArrayList listaDepAtCliente, String exp) throws P06BException{
		try {
			if(listaDepAtCliente.isEmpty())
				return;
			ArrayList listaPFDepAtCliente = null;
			ArrayList listaRespDepAtCliente = null;
			for(int i=0;i<listaDepAtCliente.size();i++){
				listaPFDepAtCliente = null;
				listaRespDepAtCliente = null;
				//Recorro los departamentos de atencin al cliente a insertar
				P06B26T00Datatype depAtCliente = (P06B26T00Datatype)listaDepAtCliente.get(i);
				depAtCliente.setNumExp(exp);
				P06B26T00DAO.getInstance().insert(depAtCliente);
				
				//En caso de que el departamento sea jurdico, se insertarn las personas fsicas que lo forman
				listaPFDepAtCliente = depAtCliente.getListaPF_DepAtCliente();
				if(listaPFDepAtCliente != null && listaPFDepAtCliente.size() > 0){
					//Recorro las personas fsicas del departamento
					for(int j=0;j<listaPFDepAtCliente.size();j++){
						P06B27T00Datatype PFDepAtCliente = (P06B27T00Datatype)listaPFDepAtCliente.get(j);
						PFDepAtCliente.setNumExp(exp);
						//Le asignamos como identificador el del departamento y en el identificador1 ir el de la propia persona fsica
						PFDepAtCliente.setIdentificador(depAtCliente.getIdentificador());
						P06B27T00DAO.getInstance().insert(PFDepAtCliente);
					}					
				}
				
				//Se insertarn los responsables del departamento
				listaRespDepAtCliente = depAtCliente.getListaRespDepAtCl();
				if(listaRespDepAtCliente != null && listaRespDepAtCliente.size() > 0){
					//Recorro los responsables del departamento
					for(int j=0;j<listaRespDepAtCliente.size();j++){
						P06B28T00Datatype respDepAtCliente = (P06B28T00Datatype)listaRespDepAtCliente.get(j);
						respDepAtCliente.setNumExp(exp);
						//Le asignamos como identificador el del departamento y en el identificador1 ir el del propio responsable
						respDepAtCliente.setIdentificador(depAtCliente.getIdentificador());
						P06B28T00DAO.getInstance().insert(respDepAtCliente);
					}					
				}	
				
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertDepAtCliente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
		
	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectSocios(String numExp) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectAllByExp(numExp,P06BConstantes.P06B_ACCIONISTA_DIRECTO);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectSocios: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectSociosIncorporacionDEC(String numExp, int nEjerIncorporarDEC) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectSociosIncorporacionDEC(numExp,P06BConstantes.P06B_ACCIONISTA_DIRECTO,nEjerIncorporarDEC);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectSociosIncorporacionDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectSociosIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectSociosIncorporacionModTramitagune(numExp,P06BConstantes.P06B_ACCIONISTA_DIRECTO,nCorrelAtencionPeticionEnRevision);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectSociosIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
    * Obtiene el ejercicio a incorporar DEC
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public int selectEjercicioIncorporarDEC(String numExp) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectEjercicioIncorporarDEC(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectEjercicioIncorporarDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene el ejercicio a incorporar DEC
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public int selectCorrelAtencionPeticionEnRevision(String numExp) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectCorrelAtencionPeticionEnRevision(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCorrelAtencionPeticionEnRevision: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene el ejercicio a incorporar DEC
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public P06B64T00Datatype selectDatosAtencPeticTramitagune(int correlativo) throws P06BException{
		try {
			return P06B64T00DAO.getInstance().selectByPK(correlativo);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCorrelAtencionPeticionEnRevision: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList<P06B61T00Datatype> selectEVs(String numExp) throws P06BException{
		try {
			return P06B61T00DAO.getInstance().selectAllByExp(numExp, P06BTablas.P06B_P06B61_EV_ENTIDAD);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectEVs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectEVsIncorporacionDEC(String numExp, int nEjerIncorporarDEC) throws P06BException{
		try {
			return P06B61T00DAO.getInstance().select61ByIncorporacionDEC(numExp, nEjerIncorporarDEC);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectEVsIncorporacionDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectEVsIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision) throws P06BException{
		try {
			return P06B61T00DAO.getInstance().select61ByIncorporacionModTramitagune(numExp, nCorrelAtencionPeticionEnRevision);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectEVsIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de socios indirectos vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios indirectos deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectSociosIndirec(String numExp) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectAllByExp(numExp,P06BConstantes.P06B_ACCIONISTA_INDIRECTO);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectSociosIndirec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Obtiene la lista de auxiliares externos vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos auxiliares externos deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectAuxExternos(String numExp) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectAllByExp(numExp, P06BConstantes.P06B_AUXILIAR_EXTERNO);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAuxExternos: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
    * Obtiene la lista de administradores vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos administradores deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectAdministradores(String numExp) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().selectAllByExp(numExp,P06BConstantes.P06B_ADMINISTRADORES);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAdministradores: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectAdministradoresIncorporacionDEC(String numExp, int nEjerIncorporarDEC) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionDEC(numExp,P06BConstantes.P06B_ADMINISTRADORES,nEjerIncorporarDEC);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAdministradoresIncorporacionDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Obtiene la lista de socios vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos socios deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectAdministradoresIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionModTramitagune(numExp,P06BConstantes.P06B_ADMINISTRADORES,nCorrelAtencionPeticionEnRevision);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAdministradoresIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	/**
    * Obtiene la lista de organos de direccin vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos organos de direccin deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectOrganosDir(String numExp) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().selectAllByExp(numExp,P06BConstantes.P06B_DIRECCION_RESPONS_MEDIACION);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectOrganosDir: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de organos de direccin vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos organos de direccin deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectOrganosDirIncorporacionDEC(String numExp, int nEjerIncorporarDEC) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionDEC(numExp,P06BConstantes.P06B_DIRECCION_RESPONS_MEDIACION, nEjerIncorporarDEC);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectOrganosDirIncorporacionDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de organos de direccin vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos organos de direccin deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectOrganosDirIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionModTramitagune(numExp,P06BConstantes.P06B_DIRECCION_RESPONS_MEDIACION, nCorrelAtencionPeticionEnRevision);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectOrganosDirIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de direccin tcnica vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos direccin tcnica deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDirecTec(String numExp) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().selectAllByExp(numExp,P06BConstantes.P06B_DIRECCION_TECNICA);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDirecTec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de direccin tcnica vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos direccin tcnica deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDirecTecIncorporacionDEC(String numExp, int nEjerIncorporarDEC) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionDEC(numExp,P06BConstantes.P06B_DIRECCION_TECNICA, nEjerIncorporarDEC);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDirecTecIncorporacionDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de direccin tcnica vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos direccin tcnica deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDirecTecIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionModTramitagune(numExp,P06BConstantes.P06B_DIRECCION_TECNICA, nCorrelAtencionPeticionEnRevision);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDirecTecIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de otros direccin vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos otros direccin deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectOtrosDirec(String numExp) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().selectAllByExp(numExp,P06BConstantes.P06B_PARTICIPES_DIRECTOS_MEDIACION);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectOtrosDirec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de otros direccin vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos otros direccin deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectOtrosDirecIncorporacionDEC(String numExp, int nEjerIncorporarDEC) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionDEC(numExp,P06BConstantes.P06B_PARTICIPES_DIRECTOS_MEDIACION, nEjerIncorporarDEC);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectOtrosDirecIncorporacionDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de otros direccin vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos otros direccin deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectOtrosDirecIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().select24ByIncorporacionModTramitagune(numExp,P06BConstantes.P06B_PARTICIPES_DIRECTOS_MEDIACION, nCorrelAtencionPeticionEnRevision);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectOtrosDirecIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de sucursales vinculadas al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyas sucursales deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectSucursales(String numExp) throws P06BException{
		try {
			return P06B25T00DAO.getInstance().selectAllByExp(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectSucursales: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de defensores de cliente vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos defensores de cliente deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDefCliente(String numExp, String tipo) throws P06BException{
		try {
			ArrayList listaDefCliente = P06B29T00DAO.getInstance().selectAllByExp(numExp, tipo);
			
			//Cargar las listas de personas fsicas para cada defensor de tipo jurdico
			if (listaDefCliente != null && listaDefCliente.size()>0){
				for(int i=0;i<listaDefCliente.size();i++){
					P06B29T00Datatype obj = (P06B29T00Datatype)listaDefCliente.get(i);
					obj.setListaPF_DefCliente(P06B30T00DAO.getInstance().selectAllByExpIdentif(numExp,obj.getIdentificador()));
				}				
			}
			
			//return P06B29T00DAO.getInstance().selectAllByExp(numExp);
			return listaDefCliente;
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDefCliente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    */
	public P06B29T00Datatype selectDefClienteAdherido(String adheridoAlColegioExpedienteFicticio, String adheridoAlColegio) throws P06BException{
		P06B29T00Datatype p06B29T00Datatype = null;
		try {
			p06B29T00Datatype = P06B29T00DAO.getInstance().selectDefClienteAdherido(adheridoAlColegioExpedienteFicticio, adheridoAlColegio);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDefClienteAdherido: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
		return p06B29T00Datatype;
	}


	/**
    */
	public P06B83T00Datatype selectDatosDireccion() throws P06BException{
		P06B83T00Datatype p06B83T00Datatype = null;
		try {
			p06B83T00Datatype = P06B83T00DAO.getInstance().selectAll();
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDatosDireccion: " + e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
		return p06B83T00Datatype;
	}


	/**
    */
	public void updateDefClienteAdherido(P06B29T00Datatype defCliente) throws P06BException{
		try {
			P06B29T00DAO.getInstance().updateDefClienteAdherido(defCliente);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - updateDefClienteAdherido: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}


	/**
    */
	public void updateAll(P06B83T00Datatype datosDireccion) throws P06BException{
		try {
			P06B83T00DAO.getInstance().updateAll(datosDireccion);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - updateAll: " + e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}


	/**
    */
	public P06B26T00Datatype selectAtClienteAdherido(String adheridoAlColegioExpedienteFicticio, String adheridoAlColegio) throws P06BException{
		P06B26T00Datatype p06B26T00Datatype = null;
		try {
			p06B26T00Datatype = P06B26T00DAO.getInstance().selectAtClienteAdherido(adheridoAlColegioExpedienteFicticio, adheridoAlColegio);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAtClienteAdherido: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
		return p06B26T00Datatype;
	}
	
			
	/**
    */
	public void updateAtClienteAdherido(P06B26T00Datatype atCliente) throws P06BException{
		try {
			P06B26T00DAO.getInstance().updateAtClienteAdherido(atCliente);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - updateAtClienteAdherido: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
		
	/**
    * Obtiene la lista de defensores de cliente vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos defensores de cliente deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDefClienteIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision, String tipo, String expedienteFicticio) throws P06BException{
		try {
			ArrayList listaDefCliente = P06B29T00DAO.getInstance().selectAllByExpIncorporacionModTramitagune(numExp, nCorrelAtencionPeticionEnRevision, tipo, expedienteFicticio);
			
			//Cargar las listas de personas fsicas para cada defensor de tipo jurdico
			if (listaDefCliente != null && listaDefCliente.size()>0){
				for(int i=0;i<listaDefCliente.size();i++){
					P06B29T00Datatype obj = (P06B29T00Datatype)listaDefCliente.get(i);
					obj.setListaPF_DefCliente(P06B30T00DAO.getInstance().selectAllByExpIdentif(numExp,obj.getIdentificador()));
				}				
			}
			
			//return P06B29T00DAO.getInstance().selectAllByExp(numExp);
			return listaDefCliente;
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDefClienteIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
		
	/**
    * Obtiene la lista de departamentos de atencin al cliente vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos departamentos de atencin al cliente deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDepAtClienteIncorporacionModTramitagune(String numExp, int nCorrelAtencionPeticionEnRevision, String tipo, String expedienteFicticio) throws P06BException{
		try {
			ArrayList listaDepAtCliente = P06B26T00DAO.getInstance().selectAllByExpIncorporacionModTramitagune(numExp, nCorrelAtencionPeticionEnRevision, tipo, expedienteFicticio);
			
			//Cargar las listas de personas fsicas para cada departamento de atencin al cliente de tipo jurdico
			if (listaDepAtCliente != null && listaDepAtCliente.size()>0){
				for(int i=0;i<listaDepAtCliente.size();i++){
					P06B26T00Datatype obj = (P06B26T00Datatype)listaDepAtCliente.get(i);
					obj.setListaPF_DepAtCliente(P06B27T00DAO.getInstance().selectAllByExpIdentif(numExp,obj.getIdentificador()));
					obj.setListaRespDepAtCl(P06B28T00DAO.getInstance().selectAllByExpIdentif(numExp,obj.getIdentificador()));
				}				
			}
			
			return listaDepAtCliente;
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDepAtClienteIncorporacionModTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	
	/**
    * Obtiene la lista de departamentos de atencin al cliente vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos departamentos de atencin al cliente deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDepAtCliente(String numExp, String tipo) throws P06BException{
		try {
			ArrayList listaDepAtCliente = P06B26T00DAO.getInstance().selectAllByExp(numExp, tipo);
			
			//Cargar las listas de personas fsicas para cada departamento de atencin al cliente de tipo jurdico
			if (listaDepAtCliente != null && listaDepAtCliente.size()>0){
				for(int i=0;i<listaDepAtCliente.size();i++){
					P06B26T00Datatype obj = (P06B26T00Datatype)listaDepAtCliente.get(i);
					obj.setListaPF_DepAtCliente(P06B27T00DAO.getInstance().selectAllByExpIdentif(numExp,obj.getIdentificador()));
					obj.setListaRespDepAtCl(P06B28T00DAO.getInstance().selectAllByExpIdentif(numExp,obj.getIdentificador()));
				}				
			}
			
			return listaDepAtCliente;
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDepAtCliente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
				
		
	/**
    * Primero eliminamos todos los socios directos asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaSocios 
    * 			Lista de socios directos a insertar
    * @param exp 
    * 			Expediente al que se asocia cada socio directo
    * @throws P06BException
    */
	public void deleteAndInsertListaSocios(ArrayList listaSocios, P06B20T00Datatype p06B20T00Datatype, String exp) throws P06BException{
		try {
			if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				P06B22T00DAO.getInstance().deleteAllByExp(exp,P06BConstantes.P06B_ACCIONISTA_DIRECTO);
			}
			for(int i=0;i<listaSocios.size();i++){
				//Recorro los socios a insertar
				P06B22T00Datatype socio = (P06B22T00Datatype)listaSocios.get(i);
				socio.setNExpediente(exp);
				if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B22T00DAO.getInstance().insert(socio);						
				}else if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (socio.getAprobado()==1){
//						if (socio.getOperacion()==0 || socio.getOperacion()==2){
//							P06B22T00DAO.getInstance().deleteByExpId(exp,P06BConstantes.P06B_ACCIONISTA_DIRECTO,socio.getIdentificador());							
//						}
						if (socio.getOperacion()==1 || socio.getOperacion()==2){
							P06B22T00DAO.getInstance().insert(socio);						
						}
//					}
				}
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaSocios: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Primero eliminamos todos los administradores asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaAdministradores 
    * 			Lista de administradores a insertar
    * @param exp 
    * 			Expediente al que se asocia cada administrador
    * @throws P06BException
    */
	public void deleteAndInsertListaAdministradores(ArrayList listaAdministradores, P06B20T00Datatype p06b20t00Datatype, String exp) throws P06BException{
		try {
			if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				P06B24T00DAO.getInstance().deleteAllByExp(exp, P06BConstantes.P06B_ADMINISTRADORES);
			}
			for(int i=0;i<listaAdministradores.size();i++){
				//Recorro los organos a insertar
				P06B24T00Datatype organo = (P06B24T00Datatype)listaAdministradores.get(i);
				organo.setnExpediente(exp);
				if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B24T00DAO.getInstance().insert(organo);
				}else if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (organo.getAprobado()==1){
//						if (organo.getOperacion()==0 || organo.getOperacion()==2){
//							P06B24T00DAO.getInstance().deleteByExpIdCargo(exp, P06BConstantes.P06B_ADMINISTRADORES,organo.getIdentificador(),organo.getIdCargo());							
//						}
						if (organo.getOperacion()==1 || organo.getOperacion()==2){
							P06B24T00DAO.getInstance().insert(organo);
						}
//					}
				}
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaAdministradores: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Primero eliminamos todos las EVs asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaEVs 
    * 			Lista de EVs a insertar
    * @param exp 
    * 			Expediente al que se asocia cada EV
    * @throws P06BException
    */
	public void deleteAndInsertListaEVs(ArrayList listaEVs, P06B20T00Datatype p06b20t00Datatype, String exp) throws P06BException{
		try {
			if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				P06B61T00DAO.getInstance().deleteAllByExp(exp);
			}
			for(int i=0;i<listaEVs.size();i++){
				//Recorro los evs a insertar
				P06B61T00Datatype ev = (P06B61T00Datatype)listaEVs.get(i);
				ev.setExpedi(exp);
				if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B61T00DAO.getInstance().insert(ev);
				}else if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (ev.getAprobado()==1){
//						if (p06b20t00Datatype.getCorrelAtencionPeticionEnRevision()==-1){
//							if (ev.getOperacion()==0 || ev.getOperacion()==2){
//								P06B61T00DAO.getInstance().deleteByExpId(exp,ev.getCif());
//							}
//							if (ev.getOperacion()==1 || ev.getOperacion()==2){
//								P06B61T00DAO.getInstance().insert(ev);
//							}							
//						}else{
//							if (ev.getOperacion()==2 && ev.getAltaBaja()==2){
//								P06B61T00DAO.getInstance().deleteByExpId(exp,ev.getCif());
//							}
//							if (ev.getOperacion()==1 && ev.getAltaBaja()==1){
//								P06B61T00DAO.getInstance().insert(ev);
//							}							
//						}
						if (ev.getOperacion()==1 || ev.getOperacion()==2){
							P06B61T00DAO.getInstance().insert(ev);
						}							
//					}
				}
			}
		}catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaEVs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	public void insertAdjuntosExpFromCorrelAtencPetic(String expediente, int correlAtencPetic) throws P06BException{
		try {
			P06B81T00DAO.getInstance().insertAdjuntosExpFromCorrelAtencPetic(expediente, correlAtencPetic);
		}catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertAllFromCorrelAtencPetic: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Primero eliminamos todos los socios INdirectos asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaSociosIndirec 
    * 			Lista de socios INdirectos a insertar
    * @param exp 
    * 			Expediente al que se asocia cada INsocio directo
    * @throws P06BException
    */
	public void deleteAndInsertListaSociosIndirec(ArrayList listaSociosIndirec, String exp) throws P06BException{
		try {
			P06B22T00DAO.getInstance().deleteAllByExp(exp,P06BConstantes.P06B_ACCIONISTA_INDIRECTO);
			for(int i=0;i<listaSociosIndirec.size();i++){
				//Recorro los socios a insertar
				P06B22T00Datatype socio = (P06B22T00Datatype)listaSociosIndirec.get(i);
				socio.setNExpediente(exp);
				P06B22T00DAO.getInstance().insert(socio);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaSociosIndirec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Primero eliminamos todos los auxiliares externos asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaAuxExternos 
    * 			Lista de auxiliares externos a insertar
    * @param exp 
    * 			Expediente al que se asocia cada auxiliar externo
    * @throws P06BException
    */
	public void deleteAndInsertListaAuxExternos(ArrayList listaAuxExternos, String exp) throws P06BException{
		try {
			P06B22T00DAO.getInstance().deleteAllByExp(exp,P06BConstantes.P06B_AUXILIAR_EXTERNO);
			for(int i=0;i<listaAuxExternos.size();i++){
				//Recorro los socios a insertar
				P06B22T00Datatype socio = (P06B22T00Datatype)listaAuxExternos.get(i);
				socio.setNExpediente(exp);
				P06B22T00DAO.getInstance().insert(socio);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaAuxExternos: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		

	/**
    * Primero eliminamos todos los rganos de direccin asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaSocios 
    * 			Lista de rganos de direccin a insertar
    * @param exp 
    * 			Expediente al que se asocia cada rgano de direccin
    * @throws P06BException
    */
	public void deleteAndInsertListaOrganosDir(ArrayList listaOrganosDir, P06B20T00Datatype p06b20t00Datatype, String exp) throws P06BException{
		try {
			if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				P06B24T00DAO.getInstance().deleteAllByExp(exp, P06BConstantes.P06B_DIRECCION_RESPONS_MEDIACION);
			}
			for(int i=0;i<listaOrganosDir.size();i++){
				//Recorro los organos a insertar
				P06B24T00Datatype organo = (P06B24T00Datatype)listaOrganosDir.get(i);
				organo.setnExpediente(exp);
				if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B24T00DAO.getInstance().insert(organo);
				}else if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (organo.getAprobado()==1){
//						if (organo.getOperacion()==0 || organo.getOperacion()==2){
//							P06B24T00DAO.getInstance().deleteByExpIdCargo(exp, P06BConstantes.P06B_DIRECCION_RESPONS_MEDIACION,organo.getIdentificador(),organo.getIdCargo());							
//						}
						if (organo.getOperacion()==1 || organo.getOperacion()==2){
							P06B24T00DAO.getInstance().insert(organo);
						}
//					}
				}
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaOrganosDir: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Primero eliminamos todos los direccin tcnica asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaDirecTec 
    * 			Lista de direccin tcnica a insertar
    * @param exp 
    * 			Expediente al que se asocia cada direccin tcnica
    * @throws P06BException
    */
	public void deleteAndInsertListaDirecTec(ArrayList listaDirecTec, P06B20T00Datatype p06b20t00Datatype, String exp) throws P06BException{
		try {
			if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				P06B24T00DAO.getInstance().deleteAllByExp(exp, P06BConstantes.P06B_DIRECCION_TECNICA);
			}
			for(int i=0;i<listaDirecTec.size();i++){
				//Recorro los organos a insertar
				P06B24T00Datatype organo = (P06B24T00Datatype)listaDirecTec.get(i);
				organo.setnExpediente(exp);
				if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B24T00DAO.getInstance().insert(organo);
				}else if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (organo.getAprobado()==1){
//						if (organo.getOperacion()==0 || organo.getOperacion()==2){
//							P06B24T00DAO.getInstance().deleteByExpIdCargo(exp, P06BConstantes.P06B_DIRECCION_TECNICA,organo.getIdentificador(),organo.getIdCargo());							
//						}
						if (organo.getOperacion()==1 || organo.getOperacion()==2){
							P06B24T00DAO.getInstance().insert(organo);
						}
//					}
				}
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaDirecTec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Primero eliminamos todos los otros direccin asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaOtrosDirec 
    * 			Lista de otros direccin a insertar
    * @param exp 
    * 			Expediente al que se asocia cada otros direccin
    * @throws P06BException
    */
	public void deleteAndInsertListaOtrosDirec(ArrayList listaOtrosDirec, P06B20T00Datatype p06b20t00Datatype, String exp) throws P06BException{
		try {
			if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				P06B24T00DAO.getInstance().deleteAllByExp(exp, P06BConstantes.P06B_PARTICIPES_DIRECTOS_MEDIACION);
			}
			for(int i=0;i<listaOtrosDirec.size();i++){
				//Recorro los organos a insertar
				P06B24T00Datatype organo = (P06B24T00Datatype)listaOtrosDirec.get(i);
				organo.setnExpediente(exp);
				if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B24T00DAO.getInstance().insert(organo);
				}else if (p06b20t00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (organo.getAprobado()==1){
//						if (organo.getOperacion()==0 || organo.getOperacion()==2){
//							P06B24T00DAO.getInstance().deleteByExpIdCargo(exp, P06BConstantes.P06B_PARTICIPES_DIRECTOS_MEDIACION,organo.getIdentificador(),organo.getIdCargo());							
//						}
						if (organo.getOperacion()==1 || organo.getOperacion()==2){
							P06B24T00DAO.getInstance().insert(organo);
						}
//					}
				}
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaOtrosDirec: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	/**
    * Primero eliminamos todos las sucursales asociadas al expediente
    * Segundo las insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaSucursales 
    * 			Lista de sucursales a insertar
    * @param exp 
    * 			Expediente al que se asocia cada sucursal
    * @throws P06BException
    */
	public void deleteAndInsertListaSucursales(ArrayList listaSucursales, String exp) throws P06BException{
		try {
			P06B25T00DAO.getInstance().deleteAllByExp(exp);
			for(int i=0;i<listaSucursales.size();i++){
				//Recorro las sucursales a insertar
				P06B25T00Datatype sucursal = (P06B25T00Datatype)listaSucursales.get(i);
				sucursal.setNumExp(exp);
				//Se asigna el valor del correlativo
				sucursal.setCorr((i+1)+"");
				P06B25T00DAO.getInstance().insert(sucursal);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaSucursales: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Primero eliminamos todos los defensores de cliente asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaDefCliente 
    * 			Lista de defensores de cliente a insertar
    * @param exp 
    * 			Expediente al que se asocia cada defensor de cliente
    * @throws P06BException
    */
	public void deleteAndInsertListaDefCliente(ArrayList listaDefCliente, P06B20T00Datatype p06B20T00Datatype, String exp) throws P06BException{
		try {
			if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				//Eliminamos todas las personas fsicas que tuvieran asignados los defensores de tipo jurdico
				P06B30T00DAO.getInstance().deleteAllByExp(exp);
				
				//Eliminamos todos los defensores de cliente
				P06B29T00DAO.getInstance().deleteAllByExp(exp,P06BConstantes.P06B_AC_CUENTACONSERVICIO);
			}
			
			if (!p06B20T00Datatype.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
				return;
			}
			//Recorro los defensores a insertar
			ArrayList listaPFDef = null;
			boolean bInsertar = false;
			for(int i=0;i<listaDefCliente.size();i++){
				listaPFDef = null;
				//Recorro los defensores de cliente a insertar
				P06B29T00Datatype defCliente = (P06B29T00Datatype)listaDefCliente.get(i);
				defCliente.setNumExp(exp);
				bInsertar = false;
				if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B29T00DAO.getInstance().insert(defCliente);						
					bInsertar = true;
				}else if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (defCliente.getAprobado()==1){
//						if (defCliente.getOperacion()==0 || defCliente.getOperacion()==2){
//							P06B29T00DAO.getInstance().deleteByExpId(exp,defCliente.getIdentificador(),p06B20T00Datatype.getTipoAtencionCliente());							
//							P06B30T00DAO.getInstance().deleteByExpId(exp,defCliente.getIdentificador());							
//						}
						if (defCliente.getOperacion()==1 || defCliente.getOperacion()==2){
							P06B29T00DAO.getInstance().insert(defCliente);
							bInsertar = true;
						}
//					}
				}
				
				if (bInsertar){
					//En caso de que el defensor sea jurdico, se insertarn las personas fsicas que lo forman
					listaPFDef = defCliente.getListaPF_DefCliente();
					if(listaPFDef != null && listaPFDef.size() > 0){
						//Recorro las personas fsicas del defensor
						for(int j=0;j<listaPFDef.size();j++){
							P06B30T00Datatype PFDefCliente = (P06B30T00Datatype)listaPFDef.get(j);
							PFDefCliente.setNumExp(exp);
							//Le asignamos como identificador el del defensor y en el identificador1 ir el de la propia persona fsica
							PFDefCliente.setIdentificador(defCliente.getIdentificador());
							P06B30T00DAO.getInstance().insert(PFDefCliente);
						}					
					}									
				}
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaDefCliente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Primero eliminamos todos los departamentos de atencin al cliente asociados al expediente
    * Segundo los insertamos otra vez los que queden una vez manipulado el corredor
    * 
    * @param listaDepAtCliente 
    * 			Lista de departamentos de atencin al cliente a insertar
    * @param exp 
    * 			Expediente al que se asocia cada departamento de atencin al cliente
    * @throws P06BException
    */
	public void deleteAndInsertListaDepAtCliente(ArrayList listaDepAtCliente, P06B20T00Datatype p06B20T00Datatype, String exp) throws P06BException{
		try {
			if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA || p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
				//Eliminamos todas las personas fsicas que tuvieran asignados los departamentos de tipo jurdico
				P06B27T00DAO.getInstance().deleteAllByExp(exp);
				
				//Eliminamos todos los responsables del departamento
				P06B28T00DAO.getInstance().deleteAllByExp(exp);
				
				//Eliminamos todos los departamentos de atencin al cliente
				P06B26T00DAO.getInstance().deleteAllByExp(exp, P06BConstantes.P06B_AC_CUENTACONSERVICIO);
			}
			
			if (!p06B20T00Datatype.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
				return;
			}
			//Recorro los departamentos a insertar
			ArrayList listaPFDepAtCliente = null;
			ArrayList listaRespDepAtCliente = null;
			boolean bInsertar = false;
			for(int i=0;i<listaDepAtCliente.size();i++){
				listaPFDepAtCliente = null;
				listaRespDepAtCliente = null;
				//Recorro los departamentos de atencin al cliente a insertar
				P06B26T00Datatype depAtCliente = (P06B26T00Datatype)listaDepAtCliente.get(i);
				depAtCliente.setNumExp(exp);
				bInsertar = false;
				if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
					P06B26T00DAO.getInstance().insert(depAtCliente);
					bInsertar = true;
				}else if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
//					if (depAtCliente.getAprobado()==1){
//						if (depAtCliente.getOperacion()==0 || depAtCliente.getOperacion()==2){
//							P06B26T00DAO.getInstance().deleteByExpId(exp,depAtCliente.getIdentificador(), p06B20T00Datatype.getTipoAtencionCliente());
//							P06B27T00DAO.getInstance().deleteByExpId(exp,depAtCliente.getIdentificador());
//							P06B28T00DAO.getInstance().deleteByExpId(exp,depAtCliente.getIdentificador());
//						}
						if (depAtCliente.getOperacion()==1 || depAtCliente.getOperacion()==2){
							P06B26T00DAO.getInstance().insert(depAtCliente);
							bInsertar = true;
						}
//					}
				}
				
				if (bInsertar){
					//En caso de que el departamento sea jurdico, se insertarn las personas fsicas que lo forman
					listaPFDepAtCliente = depAtCliente.getListaPF_DepAtCliente();
					if(listaPFDepAtCliente != null && listaPFDepAtCliente.size() > 0){
						//Recorro las personas fsicas del departamento
						for(int j=0;j<listaPFDepAtCliente.size();j++){
							P06B27T00Datatype PFDepAtCliente = (P06B27T00Datatype)listaPFDepAtCliente.get(j);
							PFDepAtCliente.setNumExp(exp);
							//Le asignamos como identificador el del departamento y en el identificador1 ir el de la propia persona fsica
							PFDepAtCliente.setIdentificador(depAtCliente.getIdentificador());
							P06B27T00DAO.getInstance().insert(PFDepAtCliente);
						}					
					}
					
					//Insertar los responsables del departamento
					listaRespDepAtCliente = depAtCliente.getListaRespDepAtCl();
					if(listaRespDepAtCliente != null && listaRespDepAtCliente.size() > 0){
						//Recorro los responsables del departamento
						for(int j=0;j<listaRespDepAtCliente.size();j++){
							P06B28T00Datatype respDepAtCliente = (P06B28T00Datatype)listaRespDepAtCliente.get(j);
							respDepAtCliente.setNumExp(exp);
							//Le asignamos como identificador el del departamento y en el identificador1 ir el del propio responsable
							respDepAtCliente.setIdentificador(depAtCliente.getIdentificador());
							P06B28T00DAO.getInstance().insert(respDepAtCliente);
						}					
					}		
				}		
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - deleteAndInsertListaDepAtCliente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Obtiene el estado a partir de la clave primaria -> N Exp.
    * 
    * @param numExp 
    * 			Clave primaria de la tabla en BD
    * @return String
    * 			Estado obtenido
    * @throws P06BException
    */
	public String selectEstadoCorredor(String numExp) throws P06BException{
		try {
			return P06B20T00DAO.getInstance().selectEstado(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectEstadoCorredor: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Obtiene el estado a partir de la clave primaria -> N Exp.
    * 
    * @param numExp 
    * 			Clave primaria de la tabla en BD
    * @return String
    * 			Estado obtenido
    * @throws P06BException
    */
	public int selectAtencPeticIncorporada(String numExp) throws P06BException{
		try {
			return P06B20T00DAO.getInstance().selectAtencPeticIncorporada(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAtencPeticIncorporada: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
		
	/**
    * Obtiene la lista de corredores que cumplen los criterios de bsqueda
    * 
    * @param whereCorredores 
    * 			Define la parte where de la select de los corredores que deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectCorredoresListadoBusqueda(String whereCorredores) throws P06BException{
		try {
			return P06B20T00DAO.getInstance().selectCorredoresListadoBusqueda(whereCorredores);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectCorredoreslistadoBusqueda: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
		
	/**
    * Inserta un registro en la BD -> en la tabla P06B31T00
    * 
    * @param obj 
    * 			Elemento que deseamos insertar
    * @return P06B31T00Datatype el documento insertado
    * @throws P06BException
    */
	public P06B31T00Datatype insertDocAdjunto(P06B31T00Datatype obj) throws P06BException{
		try {
			return P06B31T00DAO.getInstance().insert(obj);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - insertDocAdjunto: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de documentos adjuntos vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos documentos adjuntos deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDocsExpediente(String numExp) throws P06BException{
		try {
			return P06B31T00DAO.getInstance().selectAllByExp(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDocsExpediente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	
	/**
    * Obtiene la lista de documentos adjuntos vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos documentos adjuntos deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDocsTramitagune(String numExp, String idioma) throws P06BException{
		try {
			return P06B81T00DAO.getInstance().selectAllByExp(numExp, idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDocsExpediente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

		
	/**
    * Obtiene la lista de documentos adjuntos vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos documentos adjuntos deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectDocsTramitaguneAP(String numExp, int nCorrelAtencionPeticionAnadirDocs, String idioma) throws P06BException{
		try {
			return P06B82T00DAO.getInstance().selectDocsTramitaguneAP(numExp, nCorrelAtencionPeticionAnadirDocs, idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectDocsExpediente: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
    * Borra un registro de la BD -> en la tabla P06B31T00
    * 
    * @param obj 
    * 			Elemento que deseamos borrar
    * @return void
    * @throws P06BException
    */
	public void borrarDocAdjunto(P06B31T00Datatype obj) throws P06BException{
		try {
			P06B31T00DAO.getInstance().deleteByExpCorr(obj);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - borrarDocAdjunto: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Borra un registro de la BD -> en la tabla P06B31T00
    * 
    * @param obj 
    * 			Elemento que deseamos borrar
    * @return void
    * @throws P06BException
    */
	public void borrarDocTramitagune(P06B81T00Datatype obj) throws P06BException{
		try {
			P06B81T00DAO.getInstance().deleteByExpCorr(obj);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - borrarDocTramitagune: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Obtiene un registro P06B32T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B32T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B32T00Datatype selectMod01y02DEC(String numExp, String ejer) throws P06BException{
		try {
			return P06B32T00DAO.getInstance().select(numExp, ejer);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod01y02DEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene los N registros pertenecientes al listado de corredores de la pagina N
    * 
    * @param numPag
    * 			nmero de pgina cuyos N registros deseo obtener
    * @param where
    * 			where a aadir a la sentencia
    * @return P06BPage
    * 			Objeto con la informacin y la Lista de objetos P06BIPagination
    * @throws P06BException
    */
	public P06BPage getListadoDEC(String codigoVuelta, String columnaVuelta, int numPag, String where) throws P06BException{
		try {
			String sentencia = P06B32T00DAO.getInstance().getStrListadoDEC(where);
			return P06BPaginator.getElements(numPag,P06BConstantes.P06B_NUM_REG_PAG,sentencia,codigoVuelta,columnaVuelta,new P06BDECPagination());
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - getListadoDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de socios de la DEC vinculados al expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyos socios DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyos socios DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod02SociosDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B33T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod02SociosDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de cargos de admins y direc de la DEC vinculados al expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyos cargos DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyos cargos DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod02CargosDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B34T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod02CargosDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B35T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B35T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B35T00Datatype selectMod1SedesDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B35T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod1SedesDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de medios personales del Modelo 1 de la DEC vinculados al expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyos medios personales DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyos medios personales DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod1MedPerDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B36T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod1MedPerDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
	    * Obtiene la lista de medios personales del Modelo 1 de la DEC vinculados al ejercicio y tipo de mediador
	    * 
	    * @param ejer 
	    * 			Define el ejercicio cuyos medios personales DEC deseo obtener
	    * @param tipoMediador 
	    * 			Define el tipo de mediador cuyos medios personales DEC deseo obtener
	    * @return ArrayList
	    * @throws P06BException
	    */
		public ArrayList selectMod1MedPerSeguimiento(String ejer, String tipoMediador) throws P06BException{
			try {
				return P06B36T00DAO.getInstance().selectAllByEjerTipoMediador(ejer, tipoMediador);
			} catch (Exception e) {
				P06BLog.send(0,this,"P06BCorredoresManager - selectMod1MedPerSeguimiento: "+e.getMessage());
				throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
			}
		}
		
		/**
		    * Obtiene la lista de medios personales del Modelo 1 de la DEC vinculados al ejercicio y tipo de mediador
		    * 
		    * @param ejer 
		    * 			Define el ejercicio cuyos medios personales DEC deseo obtener
		    * @param tipoMediador 
		    * 			Define el tipo de mediador cuyos medios personales DEC deseo obtener
		    * @return ArrayList
		    * @throws P06BException
		    */
			public ArrayList selectMod1MedPerSeguimiento2(String ejer) throws P06BException{
				try {
					return P06B36T00DAO.getInstance().selectAllByEjer(ejer);
				} catch (Exception e) {
					P06BLog.send(0,this,"P06BCorredoresManager - selectMod1MedPerSeguimiento2: "+e.getMessage());
					throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
				}
			}
			
	/**
    * Obtiene un registro P06B37T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B37T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B37T00Datatype selectMod21DEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B37T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod21DEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
    * Obtiene la lista de ramos no vida del Modelo 2.2 de la DEC vinculados al expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyos ramos no vida DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyos ramos no vida DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod22DEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B38T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod22DEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
	    * Obtiene la lista de ramos no vida del Modelo 2.2 de la DEC vinculados al expediente y ejercicio
	    * 
	    * @param ejer 
	    * 			Define el ejercicio cuyos ramos no vida DEC deseo obtener
	    * @param tipoMediador 
	    * 			Define el exp cuyos ramos no vida DEC deseo obtener
	    * @return ArrayList
	    * @throws P06BException
	    */
		public ArrayList selectMod22Seguimiento(String ejer, String tipoMediador) throws P06BException{
			try {
				return P06B38T00DAO.getInstance().selectAllByEjerTipoMediador(ejer, tipoMediador);
			} catch (Exception e) {
				P06BLog.send(0,this,"P06BCorredoresManager - selectMod22Seguimiento: "+e.getMessage());
				throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
			}
		}
		
		/**
		    * Obtiene la lista de ramos no vida del Modelo 2.2 de la DEC vinculados al expediente y ejercicio
		    * 
		    * @param ejer 
		    * 			Define el ejercicio cuyos ramos no vida DEC deseo obtener
		    * @param tipoMediador 
		    * 			Define el exp cuyos ramos no vida DEC deseo obtener
		    * @return ArrayList
		    * @throws P06BException
		    */
			public ArrayList selectMod22Seguimiento2(String ejer) throws P06BException{
				try {
					return P06B38T00DAO.getInstance().selectAllByEjer(ejer);
				} catch (Exception e) {
					P06BLog.send(0,this,"P06BCorredoresManager - selectMod22Seguimiento2: "+e.getMessage());
					throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
				}
			}
			
	/**
    * Obtiene un registro P06B39T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B39T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B39T00Datatype selectMod23DEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B39T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod23DEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B40T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B40T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B40T00Datatype selectMod3DEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B40T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod3DEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de justificantes adjuntos a la DEC vinculada al expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio
    * @param numExp 
    * 			Define el exp
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectJustifAdjuntosDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B42T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		}catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectJustifAdjuntosDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}	
	
	/**
    * Obtiene la lista de entidades vinculadas del Modelo 0 de la DEC relacionados con el expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyas entidades DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyas entidades DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod0EntVincDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B43T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod0EntVincDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de entidades de Crdito del Modelo 0 de la DEC relacionados con el expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyas entidades DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyas entidades DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod0EntCredDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B44T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod0EntCredDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B45T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B45T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B45T00Datatype selectMod1SedeProfDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B45T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod1SedeProfDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
    * Obtiene la lista de Sucursales del Modelo 1 de la DEC relacionados con el expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyas sucursales DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyas sucursales DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod1SucurDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B46T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod1SucurDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene la lista de Entidades del Modelo 21 de la DEC relacionados con el expediente y ejercicio
    * 
    * @param ejer 
    * 			Define el ejercicio cuyas entidades DEC deseo obtener
    * @param numExp 
    * 			Define el exp cuyas entidades DEC deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectMod21PrimEntDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B47T00DAO.getInstance().selectAllByEjerExp(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod21PrimEntDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B48T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B48T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B48T00Datatype selectMod3InvValAnadDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B48T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod3InvValAnadDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B49T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B49T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B49T00Datatype selectMod31DEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B49T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod31DEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B50T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B50T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B50T00Datatype selectMod32DEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B50T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod32DEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B51T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B51T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B51T00Datatype selectMod33ActivoDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B51T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod33ActivoDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B51T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param tipoMediador 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B51T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B51T00Datatype selectMod33ActivoSeguimiento(String ejer, String tipoMediador) throws P06BException{
		try {
			return P06B51T00DAO.getInstance().selectTipoMediador(ejer, tipoMediador);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod33ActivoSeguimiento: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B51T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param tipoMediador 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B51T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B51T00Datatype selectMod33ActivoSeguimiento2(String ejer) throws P06BException{
		try {
			return P06B51T00DAO.getInstance().selectSumOfEjer(ejer);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod33ActivoSeguimiento2: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	/**
    * Obtiene un registro P06B52T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B52T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B52T00Datatype selectMod33PasivoDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B52T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod33PasivoDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
	    * Obtiene un registro P06B52T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
	    * 
	    * @param tipoMediador 
	    * 			Parte de la clave primaria de la tabla en BD
	    * @param ejer 
	    * 			Parte de la clave primaria de la tabla en BD
	    * @return P06B52T00Datatype
	    * 			ValueObject obtenido
	    * @throws P06BException
	    */
		public P06B52T00Datatype selectMod33PasivoSeguimiento(String ejer, String tipoMediador) throws P06BException{
			try {
				return P06B52T00DAO.getInstance().selectTipoMediador(ejer, tipoMediador);
			} catch (Exception e) {
				P06BLog.send(0,this,"P06BCorredoresManager - selectMod33PasivoSeguimiento: "+e.getMessage());
				throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
			}
		}
		
		/**
		    * Obtiene un registro P06B52T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
		    * 
		    * @param tipoMediador 
		    * 			Parte de la clave primaria de la tabla en BD
		    * @param ejer 
		    * 			Parte de la clave primaria de la tabla en BD
		    * @return P06B52T00Datatype
		    * 			ValueObject obtenido
		    * @throws P06BException
		    */
			public P06B52T00Datatype selectMod33PasivoSeguimiento2(String ejer) throws P06BException{
				try {
					return P06B52T00DAO.getInstance().selectSumOfEjer(ejer);
				} catch (Exception e) {
					P06BLog.send(0,this,"P06BCorredoresManager - selectMod33PasivoSeguimiento: "+e.getMessage());
					throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
				}
			}
			
	/**
    * Obtiene un registro P06B53T00Datatype a partir de la clave primaria -> N Exp. y ejercicio
    * 
    * @param numExp 
    * 			Parte de la clave primaria de la tabla en BD
    * @param ejer 
    * 			Parte de la clave primaria de la tabla en BD
    * @return P06B53T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B53T00Datatype selectMod3VincDEC(String ejer, String numExp) throws P06BException{
		try {
			return P06B53T00DAO.getInstance().select(ejer, numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectMod3VincDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
		
	/**
    * Obtiene el objeto vinculado a los parametros de entrada
    * 
    * @param numExp 
    * 			Define el exp cuyo objeto deseo obtener
    * @param tipo 
    * 			Define el tipo (admin, direc. tecnica, etc.) cuyo objeto deseo obtener
    * @param identificador 
    * 			Define el identificador (cif o nif) cuyo objeto deseo obtener
    * @param idCargo 
    * 			Define el idCargo cuyo objeto deseo obtener
    * @return P06B24T00Datatype
    * @throws P06BException
    */
	public P06B24T00Datatype selectAdminDirecPK(String numExp, String tipo, String identificador, String idCargo, String idioma) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().selectByPK(numExp, tipo, identificador, idCargo, idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectAdminDirecPK: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Obtiene el numero de objetos del expediente y tipo indicados
    * 
    * @param numExp 
    * 			Define el exp cuyo objeto deseo obtener
    * @param tipo 
    * 			Define el tipo (admin, direc. tecnica, etc.) cuyo objeto deseo obtener
    * @return int: numero de objetos que cumple los parametros de entrada
    * @throws P06BException
    */
	public int selectNumAdminDirec(String numExp, String tipo) throws P06BException{
		try {
			return P06B24T00DAO.getInstance().selectNumObj(numExp, tipo);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectNumObj: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Obtiene el objeto vinculado a los parametros de entrada
    * 
    * @param numExp 
    * 			Define el exp cuyo objeto deseo obtener
    * @param tipo 
    * 			Define el tipo (socio direc, indirec, aux externo) cuyo objeto deseo obtener
    * @param identificador 
    * 			Define el identificador (cif o nif) cuyo objeto deseo obtener
    * @return P06B22T00Datatype
    * @throws P06BException
    */
	public P06B22T00Datatype selectSocioPK(String numExp, String tipo, String identificador, String idioma) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectByPK(numExp, tipo, identificador, idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectSocioPK: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Obtiene el objeto vinculado a los parametros de entrada
    * 
    * @param numExp 
    * 			Define el exp cuyo objeto deseo obtener
    * @param identificador 
    * 			Define el identificador (cif o nif) cuyo objeto deseo obtener
    * @return P06B61T00Datatype
    * @throws P06BException
    */
	public P06B61T00Datatype selectEVPK(String numExp, String identificador, String idioma) throws P06BException{
		try {
			return P06B61T00DAO.getInstance().selectByPK(numExp, identificador, idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectEVPK: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
		
	/**
    * Obtiene el numero de objetos del expediente y tipo indicados
    * 
    * @param numExp 
    * 			Define el exp cuyo objeto deseo obtener
    * @param tipo 
    * 			Define el tipo (socio directo, indirecto o auxiliar externo) cuyo objeto deseo obtener
    * @return int: numero de objetos que cumple los parametros de entrada
    * @throws P06BException
    */
	public int selectNumSocios(String numExp, String tipo) throws P06BException{
		try {
			return P06B22T00DAO.getInstance().selectNumObj(numExp, tipo);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectNumSocios: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	
	/**
    * Obtiene el numero de objetos del expediente y tipo indicados
    * 
    * @param numExp 
    * 			Define el exp cuyo objeto deseo obtener
    * @return int: numero de objetos que cumple los parametros de entrada
    * @throws P06BException
    */
	public int selectNumEVs(String numExp) throws P06BException{
		try {
			return P06B61T00DAO.getInstance().selectNumObj(numExp);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectNumEVs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

		
	/**
    * Obtiene el objeto con los datos del informe resumen de la DEC
    * 
    * @param ejerDEC 
    * 			Define el ejercicio de la DEC
    * @return P06BInformeDEC
    * @throws P06BException
    */
	public P06BInformeDEC selectInformeResumenDEC(String ejerDEC) throws P06BException{
		try {
			P06BInformeDEC objInformeDEC = new P06BInformeDEC();
			
			//Obtener el nmero de mediadores que han enviado la DEC, el total
			P06B32T00DAO.getInstance().selectNumMediadEnviadaDEC(ejerDEC, objInformeDEC, null);
			
			//--------------- MODELO 1 --------------------------------
			//Corredores: N de empresas(n de mediadores que han presenrtado la DEC)
			P06B32T00DAO.getInstance().selectNumMediadEnviadaDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_CORR);
			//Corredores: Organo de direccion
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_DIREC, P06BConstantes.P06B_CORR);
			//Corredores: Empleados
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_EMPL, P06BConstantes.P06B_CORR);
			//Corredores: Otro personal
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_OTRO, P06BConstantes.P06B_CORR);				
			//Corredores: N de oficinas
			P06B46T00DAO.getInstance().selectNumOfisInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_CORR);
			
			//Vinculados: N de empresas(n de mediadores que han presenrtado la DEC)
			P06B32T00DAO.getInstance().selectNumMediadEnviadaDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_VINC);
			//Vinculados: Organo de direccion
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_DIREC, P06BConstantes.P06B_VINC);
			//Vinculados: Empleados
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_EMPL, P06BConstantes.P06B_VINC);
			//Vinculados: Otro personal
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_OTRO, P06BConstantes.P06B_VINC);
			//Vinculados: N de oficinas
			P06B46T00DAO.getInstance().selectNumOfisInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_VINC);
			
			//Operador Banca: N de empresas(n de mediadores que han presenrtado la DEC)
			P06B32T00DAO.getInstance().selectNumMediadEnviadaDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_OBS);
			//Operador Banca: Organo de direccion
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_DIREC, P06BConstantes.P06B_OBS);
			//Operador Banca: Empleados
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_EMPL, P06BConstantes.P06B_OBS);
			//Operador Banca: Otro personal
			P06B36T00DAO.getInstance().selectMedPerFormacInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_DEC_MEDPER_OTRO, P06BConstantes.P06B_OBS);
			//Operador Banca: N de oficinas
			P06B46T00DAO.getInstance().selectNumOfisInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_OBS);
			
			
			//--------------- MODELO 2 --------------------------------
			//Corredores: Campos auxiliares, otros corredores, primas cobertura inmediata y no inmediata
			P06B37T00DAO.getInstance().selectRedPropiaExtInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_CORR);
			//Corredores: Prima intermediada y comisiones vida y No vida
			P06B38T00DAO.getInstance().selectRamosNoVidaInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_CORR);
			P06B39T00DAO.getInstance().selectRamosVidaInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_CORR);			
			
			//Vinculados: Campos auxiliares, otros corredores, primas cobertura inmediata y no inmediata)
			P06B37T00DAO.getInstance().selectRedPropiaExtInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_VINC);
			//Vinculados: Prima intermediada y comisiones vida y No vida
			P06B38T00DAO.getInstance().selectRamosNoVidaInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_VINC);
			P06B39T00DAO.getInstance().selectRamosVidaInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_VINC);
			
			//Operador Banca: Campos auxiliares, otros corredores, primas cobertura inmediata y no inmediata
			P06B37T00DAO.getInstance().selectRedPropiaExtInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_OBS);
			//Operador Banca: Prima intermediada y comisiones vida y No vida
			P06B38T00DAO.getInstance().selectRamosNoVidaInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_OBS);
			P06B39T00DAO.getInstance().selectRamosVidaInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_OBS);
					
			
			//--------------- MODELO 3 --------------------------------
			//Corredores: Valor aadido e Inversin bruta
			P06B48T00DAO.getInstance().selectInvBrutaValAnadInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_CORR);
			//Corredores:Ingresos y gastos del Modelo 31
			P06B49T00DAO.getInstance().selectDatContabMod31InformeDEC(ejerDEC, objInformeDEC);
			//Corredores:Ingresos y gastos del Modelo 32
			P06B50T00DAO.getInstance().selectDatContabMod32InformeDEC(ejerDEC, objInformeDEC);
			
			//Vinculados: Valor aadido e Inversin bruta
			P06B48T00DAO.getInstance().selectInvBrutaValAnadInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_VINC);
			//Vinculados: Ingresos y gastos
			P06B53T00DAO.getInstance().selectDatContabVincYObsInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_VINC);
			
			//Operador Banca: Valor aadido e Inversin bruta
			P06B48T00DAO.getInstance().selectInvBrutaValAnadInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_OBS);
			//Operador Banca: Ingresos y gastos
			P06B53T00DAO.getInstance().selectDatContabVincYObsInformeDEC(ejerDEC, objInformeDEC, P06BConstantes.P06B_OBS);
						
			
			return objInformeDEC;
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BCorredoresManager - selectInformeResumenDEC: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

	/**
	    * Obtiene el objeto con los datos del informe otro resumen de la DEC
	    * 
	    * @param ejerDEC 
	    * 			Define el ejercicio de la DEC
	    * @return P06BInformeOtroDEC
	    * @throws P06BException
	    */
		public P06BInformeOtroDEC selectInformeOtroResumenDEC(String ejerDEC) throws P06BException{
			try {
				P06BInformeOtroDEC objInformeOtroDEC = new P06BInformeOtroDEC();
				
				//ta01, ta02, ta03 y ta04.- Primas, comisiones, honorarios por ramo
				P06B39T00DAO.getInstance().selectDatosInformeOtroDEC(ejerDEC, objInformeOtroDEC);
				P06B38T00DAO.getInstance().selectDatosInformeOtroDEC(ejerDEC, objInformeOtroDEC);
				//tb03 y tb04.- Comisiones percibidas, ingresos-gastos
				P06B53T00DAO.getInstance().selectDatosInformeOtroDEC(ejerDEC, objInformeOtroDEC);
				//tb05.- Detalle de mediadores
				P06B48T00DAO.getInstance().selectDatosInformeOtroDEC(ejerDEC, objInformeOtroDEC);
				//ta01.- Comisiones percibidas y Honorarios profesionales
				P06B49T00DAO.getInstance().selectDatosInformeOtroDEC(ejerDEC, objInformeOtroDEC);
							
				
				return objInformeOtroDEC;
			} catch (Exception e) {
				P06BLog.send(0,this,"P06BCorredoresManager - selectInformeOtroResumenDEC: "+e.getMessage());
				throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
			}
		}	
		public ArrayList<P06BInformeOtroDECDet> selectInformeOtroResumenDECDet(String ejerDEC) throws P06BException{
			try {
				ArrayList<P06BInformeOtroDECDet> p06BInformeOtroDECDet = new ArrayList<P06BInformeOtroDECDet>();
				
				//ta01, ta02, ta03 y ta04.- Primas, comisiones, honorarios por ramo
				P06BJoinsDAO.getInstance().selectDatosInformeOtroDECDet(ejerDEC, p06BInformeOtroDECDet);
											
				return p06BInformeOtroDECDet;
			} catch (Exception e) {
				P06BLog.send(0,this,"P06BCorredoresManager - selectInformeOtroResumenDEC: "+e.getMessage());
				throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
			}
		}	
		public ArrayList<P06B64T00Datatype> selectInformePetTramitagune() throws P06BException{
			try {
//				ArrayList<P06B64T00Datatype> p06BInformeOtroDECDet2 = new ArrayList<P06B64T00Datatype>();
				
				return P06B64T00DAO.getInstance().selectListado();
			} catch (Exception e) {
				P06BLog.send(0,this,"P06BCorredoresManager - selectInformePetTramitagune: "+e.getMessage());
				throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
			}
		}	
		public InformeComunicarDGSFP2 selectInformeComunicarDGSFP2(InformeComunicarDGSFP2 informeComunicarDGSFP2) throws P06BException{
			try {
//				ArrayList<P06B64T00Datatype> p06BInformeOtroDECDet2 = new ArrayList<P06B64T00Datatype>();
				
				ArrayList<P06B20T00Datatype> listaP06B20T00Datatype = P06B20T00DAO.getInstance().selectInformeComunicarDGSFP2();
				informeComunicarDGSFP2.setDatosInscripcion(listaP06B20T00Datatype);
				ArrayList<P06B61T00Datatype> listaP06B61T00Datatype = P06B61T00DAO.getInstance().selectAllByExp(null, P06BTablas.P06B_P06B61_EV_NUMEXP + ", " + P06BTablas.P06B_P06B61_EV_CLAVECAT + ", " + P06BTablas.P06B_P06B61_EV_ENTIDAD);
				informeComunicarDGSFP2.setEmpresasVinculadas(listaP06B61T00Datatype);
				ArrayList<P06B26T00Datatype> listaP06B26T00Datatype = P06B26T00DAO.getInstance().selectInformeComunicarDGSFP2();
				informeComunicarDGSFP2.setAtencionCliente(listaP06B26T00Datatype);
				ArrayList<P06B29T00Datatype> listaP06B29T00Datatype = P06B29T00DAO.getInstance().selectInformeComunicarDGSFP2();
				informeComunicarDGSFP2.setDefensaCliente(listaP06B29T00Datatype);
				ArrayList<P06B22T00Datatype> listaP06B22T00Datatype = P06B22T00DAO.getInstance().selectInformeComunicarDGSFP2();
				informeComunicarDGSFP2.setSocios(listaP06B22T00Datatype);
				ArrayList<P06B24T00Datatype> listaP06B24T00Datatype = P06B24T00DAO.getInstance().selectInformeComunicarDGSFP2();
				informeComunicarDGSFP2.setAltosCargos(listaP06B24T00Datatype);
				return informeComunicarDGSFP2;
			} catch (Exception e) {
				P06BLog.send(0,this,"P06BCorredoresManager - selectInformeComunicarDGSFP2: "+e.getMessage());
				throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
			}
		}	

}
